<?php
include_once "config.php";
include_once "lib/dsql.php";

class IMDB {
  private $URL="http://www.omdbapi.com/?apikey=2ed4c17b";
  private $IMDB_API="https://imdb-api.com/pt-BR/API/Title/k_ov0sc093/";
  //k_ov0sc093
  private $library="";
  private $cache="";
  private $ident;
  
  public $data;
  public $json;
  //FullActor,FullCast,Posters,Images,Trailer,Ratings,Wikipedia,
  //https://imdb-api.com/pt-BR/API/Title/k_vj0x5k6l/tt1375666/FullActor,FullCast,Posters,Images,Trailer,Ratings,Wikipedia,
  //k_vj0x5k6l
  
  public function __construct($ident){
    $this->library = $GLOBALS["library"]["path"]; 
    $this->cache = $GLOBALS["library"]["cache"]; 
    if($ident!="") { 
      $this->ident=$ident;
      $this->GetData($ident);
      $this->LOG($ident,"\n\n###############\nCreating","\n".$this->library."\n"); 
      $this->CreateDirectory($this->library."$ident/");    
    }
  }  
  
  public function Data(){
    return $this->data;
  }
  
  private function i_get_data($url,$cache) {
    //$json='{"id":"tt0088939","title":"Inception","originalTitle":"","fullTitle":"Inception (2010)","type":"Movie","year":"2010"}';
    $json=file_get_contents($url); 
    $data = json_decode($json);
    
    if(isset($data->errorMessage)) {
      return $data;
    }

    if($cache) {    
      $ident=$data->id;     
      $LIBPATH = $this->library.$ident;       
      $this->CreateDirectory($LIBPATH);   
      $this->LOG($ident,"i_get_data","caching file $LIBPATH");
      file_put_contents("$LIBPATH/imdbapi.json",$json);   
    } else {
      $this->LOG($ident,"i_get_data","not caching file $LIBPATH/imdbapi.json");
    } 
    $this->data=$data;
    return $data;                
  }
    
  public function iGetData($ident) {
    if($ident=="") $ident=$this->ident;
    $url = $this->library."$ident/imdbapi.json";  
    $cache=true;
    if(!file_exists($url)){ 
      $url="$this->IMDB_API$ident/FullActor,FullCast,Posters,Images,Trailer,Ratings,Wikipedia,";
      $this->LOG($ident,"iGetData","cache not found: using $url");
    } else {
      $this->LOG($ident,"iGetData","cache found: using $url");
      $cache=false;
    }
    return $this->i_get_data($url,$cache);    
  }  
  
  public function iSearchTitle($title,$year) {
    $url = $this->URL."&t$title&$year";
    //$data = json_decode(file_get_contents($url));
    return $data;     
  }
  
  public function iSearch($title,$year) {
  }  
    
  
  
  public function CreateDirectory($LIBPATH) {
    if(!file_exists($LIBPATH)) {
      mkdir($LIBPATH, 0777, true);
      $this->LOG($ident,"i_get_data","Creating directory $LIBPATH");  
    }    
  }
  
  public function CreateImages($ident) {
    if($ident=="") $ident=$this->ident;    
    $path=$this->library."$ident/";
    $imagick = new Imagick("$path/$ident.jpg");
    $imagick->resizeImage(256,256,Imagick::FILTER_UNDEFINED,1,true);
    $imagick->writeImage("$path/cover.jpg");
    $imagick->resizeImage(48,48,Imagick::FILTER_UNDEFINED,1,true);
    $imagick->writeImage("$path/icon.jpg");        
  }
  
  private function _curl($URL) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_URL, $URL);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;    
  }    
  
  
/*
{"Title":"Wall Street","Year":"1987","Rated":"R","Released":"11 Dec 1987","Runtime":"126 min","Genre":"Crime, Drama",
"Director":"Oliver Stone","Writer":"Stanley Weiser, Oliver Stone","Actors":"Charlie Sheen, Michael Douglas, Tamara Tunie",
"Plot":"A young and impatient stockbroker is willing to do anything to get to the top, including trading on illegal inside information taken through a ruthless and greedy corporate raider who takes the youth under his wing.",
"Language":"English","Country":"United States","Awards":"Won 1 Oscar. 10 wins & 5 nominations total",
"Poster":"https://m.media-amazon.com/images/M/MV5BNmEyZGQ4NDQtNTEzZC00MDczLWE4ZTEtYTg0ODg2NTkyMWM3XkEyXkFqcGdeQXVyNjU0OTQ0OTY@._V1_SX300.jpg",
"Ratings":[{"Source":"Internet Movie Database","Value":"7.3/10"},{"Source":"Rotten Tomatoes","Value":"79%"},
{"Source":"Metacritic","Value":"56/100"}],"Metascore":"56","imdbRating":"7.3","imdbVotes":"153,670","imdbID":"tt0094291",
"Type":"movie","DVD":"19 Feb 2002","BoxOffice":"$43,848,069","Production":"N/A","Website":"N/A","Response":"True"}  
* 
* 
{"Response":"False","Error":"Movie not found!"}

                                                                                                                   
*/  

  private function LOG($ident,$func,$text) {
    if($ident=="")$ident=$this->ident;
    $LIBPATH = $this->library."$ident/imdb.log";
    $txt = "$func : ".date("Y/m/d h:i:sa")." ($ident ):  $text\n";
    file_put_contents("$LIBPATH",$txt, FILE_APPEND);  
  }
  
  private function SaveFile($ident,$fname,$content) {
    if($ident=="")$ident=$this->ident;
    file_put_contents($this->library."$ident/$fname",$content);
  }
  
  public function GetPosterUrl($ident,$url,$source,$force) {
    if($ident=="") $ident=$this->ident;
    if(!$force) $poster=file_get_contents($url);
    $data=$this->GetData($ident);
    if($poster && !$force){
      //echo "posterOK:$url";      
      $this->LOG($ident,"GetPosterUrl","posterOK: $url");
      $this->SaveFile($ident,"$ident.jpg",$poster);
      return $poster;      
    } else {
      //echo "poster not found (trying other source):$url";   
      $this->LOG($ident,"GetPosterUrl","poster N/A forced($force):\n$url");   
      $poster=$this->GetPoster($ident);     
      if($poster) $this->SaveFile($ident,"$ident.jpg",$poster);                   
      return $poster; 
    }    
  }
  
  private function _get_poster($ident,$url,$save) {
    $this->LOG($ident,"_get_poster","Stating for $ident:$url");      
    $poster=file_get_contents($url);  
    if($save && $poster) {
      $this->SaveFile($ident,"$ident.jpg",$poster);      
    }
    return $poster;
  }
    
  public function GetPoster($ident) {
    if($ident=="")$ident=$this->ident;
    $url = $this->URL."&i=$ident";  
    $data = $this->GetData($ident);
    //$url='/tetetee';//$data->Poster;
    $url=$data->Poster;    
    $helper=new cSQLHelper("update","movies"); 
    $helper->AddValue("poster2",$url);
    $helper->AddClause("ident",$ident,"",true);
    $helper->Execute();    
    return $this->_get_poster($ident,$url,false);  
  }
  
  private function _get_data($url,$cache) {
    $json=file_get_contents($url); 
    $this->json=$json;
    $data = json_decode($json);
    if($data->Response="True") {    
      $ident=$data->imdbID;     
      $this->ident=$ident;
      $LIBPATH = $this->library.$ident;  
      $this->CreateDirectory($LIBPATH);               
      $this->LOG($ident,"_get_data","caching file $LIBPATH");
      if($this->cache!="") file_put_contents($this->cache."$ident.json",$json); 
      if($cache) file_put_contents("$LIBPATH/omdbapi.json",$json);   
    } else {
      $this->LOG($ident,"_get_data","not caching file $LIBPATH/omdbapi.json");
    } 
    $this->data=$data;    
    return $data;                
  }
  
  public function GetDataForced($ident) { 
    if($ident=="") $ident=$this->ident;
    $url = $this->URL."&i=$ident";
    return $this->_get_data($url,true);
  }  
  
  public function GetData($ident) { 
    if($ident=="") $ident=$this->ident;
    $url = $this->library."$ident/omdbapi.json";  
    $cache=true;
    if(!file_exists($url)){ 
      $url = $this->URL."&i=$ident";
      $this->LOG($ident,"getdata","cache not found: using $url");
    } else {
      $this->LOG($ident,"getdata","cache found: using $url");
      $cache=false;
    }
    return $this->_get_data($url,$cache);
  }

  public function GetByTitle($title,$year) {
    $url = $this->URL."&t=$title&y=$year";
    return _get_data($url,true);     
  }    
  
  /*****************************************
   * MYSQL FUNCTIONS************
   * **************************************/
  
  private function _create_mysql_insert() {
    $ident=$this->ident;
    $dt = new cMysqlDateTime();
    $helper=new cSQLHelper("insert","movies");
    $helper->ForceUpdate(true);    
    $helper->AddText("ident","$ident",false);//$this->data->imdbID);
    $helper->AddValue("title",$this->data->Title);
    $helper->AddValue("year",$this->data->Year);    
    $helper->AddValue("original",$this->data->Title);
    $helper->AddValue("plot",$this->data->Plot);  
    $helper->AddText("poster",$this->data->Poster,false);      
    $helper->AddValue("poster2",$this->data->Poster);  
    $helper->AddValue("filename","n/a");
    $helper->AddValue("ofilename","n/a");  
    $helper->AddValue("actors",$this->data->Actors);
    
    $helper->AddFunctionUpdate("last_mod","CurDate()");  
     
    
    $helper->AddValue("genre",$this->Genre);
    $helper->AddValue("country",$this->Country);    
    
    $helper->AddValue("Language",$this->Language);  
     
    
    $helper->AddNum("status",0,false);   
    $helper->AddNum("avaliable",0,false);   
    
    
    $helper->AddValue("director",$this->data->Director);
    $helper->AddValue("writer",$this->data->Writer);    
    
    $helper->AddValue("json_text",$this->json);
    
    $this->_get_poster($ident,$this->data->Poster,true);
    $this->CreateImages("");
    /*
    $sql="INSERT INTO `allkubo_movies`.`movies` VALUES (
      `ident`='$ident'
    ";
    */
    $helper->Execute();
    return $helper->resultMessage();
    //return $helper->GetQuery();
        
  }
  
  public function CreateInsertFromSearch(){
    return $this->_create_mysql_insert($this->ident);
  }
  
  
  /*************************************
   * SEARCH FOR TITLES
   * **********************************/
  private $sdata;  
  private $sindex=0;
  private $scount=0;
  private $ssel=null;
  private $stotal=0;
  private $page=0;
  public function SearchForTitle($title,$type,$year) {
  }
  public function SearchTitle($title,$type,$year,$page) {
    $url = $this->URL."&s=$title&r=json";
    if($year!="")$url="$url&y=$year";
    if($type!="")$url="$url&type=$type";
    if($page!="")$url="$url&page=$page";
    //echo "$url<br><br>";
    $temp=file_get_contents($url);
    $this->sdata=json_decode($temp);
    if(isset($this->sdata->Search)) {
      $this->stotal=$this->sdata->totalResults;
      $this->scount=count($this->sdata->Search);
      $this->First();
    } else {
      $this->scount=0;
      $this->ssel=null;
      $this->sindex=0;      
    }
    return $temp;    
  }  
  
  public function TotalCount() {
    return $this->stotal;
  }
  
  public function TotalPages() {
    $t=gmp_div_q($this->stotal,10);
    if(gmp_div_r($this->stotal,10)>0)$t++;
    return $t;
  }
    
  public function sprint() {
    echo "<br><br><br>$this->scount:$this->sindex<br>";  
    if($this->ssel!=null)
      print_r((array)$this->ssel);    
  }  
  
  public function First() {
    if($this->scount>0) {
      $this->sindex=0;
      $this->ssel=$this->sdata->Search[$this->sindex];   
    }
  }
  
  public function Last() {
    if($this->scount>=1) $this->sindex=$this->scount-1;
    $this->ssel=$this->sdata->Search[$this->sindex];   
  }  
  
  public function BOF() {
    if($this->sindex>=0)return false;
    return true;
  }  
  
  public function Prior() {
    if(!$this->BOF()) {
      $this->sindex--;
      if($this->sindex>=0)$this->ssel=$this->sdata->Search[$this->sindex];
      else return false;  
      return true; 
    } else {
      return false;
    }
  }    

  public function EOF() {
    if($this->sindex<($this->scount))return false;
    return true;
  }
  
  public function Next() {    
    if(!$this->EOF()) {  
      $this->sindex++;   
      if(!$this->EOF())
        $this->ssel=$this->sdata->Search[$this->sindex];
      else return false;
      return true; 
    } else {
      return false;
    }
  }    
  
  public function GetValue($name) {
    return ((array)$this->ssel)[$name];
  }
  

};

?>
